/*
 * Decompiled with CFR 0.152.
 */
package acmx.export;

import acm.program.Program;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import acmx.classfile.ClassTransformer;
import acmx.classfile.JavaClass;
import acmx.export.Base64OutputStream;
import acmx.export.ExportAppletDialog;
import acmx.export.JDK11Transformer;
import acmx.export.MailStream;
import acmx.export.NullOutputStream;
import acmx.export.ProgressBarDialog;
import acmx.export.SubmitOptions;
import acmx.export.ThreadedMenuAction;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ExportTools {
    private static final String[] SKIP_FILES = new String[]{".DS_Store", "FINDER.DAT", "RESOURCE.FRK"};
    private static final String[] RESOURCE_EXTENSIONS = new String[]{".txt", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav", ".class"};
    private static final String[] SUBMIT_EXTENSIONS = new String[]{".java", ".html", ".txt", ".gif", ".jpg", ".jpeg", ".png", ".au", ".wav"};
    private static HashMap<Component, SubmitOptions> optionsTable = new HashMap();

    private ExportTools() {
    }

    public static PrintStream openMailStream(String smtpServer, String from, String to) {
        return new MailStream(smtpServer, from, to);
    }

    public static void cancelMail(PrintStream out) {
        ((MailStream)out).cancel();
    }

    public static void sendStandardHeaders(PrintStream out, String senderName, String subject) {
        ((MailStream)out).sendStandardHeaders(senderName, subject);
    }

    public static OutputStream openBase64OutputStream(PrintStream printStream) {
        return new Base64OutputStream(printStream);
    }

    public static void padBase64OutputStream(OutputStream out) {
        ((Base64OutputStream)out).pad();
    }

    public static void exportJar(File jarFile, File dir, String libName, ClassTransformer transformer) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jarFile));
            ExportTools.dumpJarAndResources("", dir, out, null, libName, null, transformer, false);
            out.close();
            if (Platform.isMac()) {
                Platform.setFileTypeAndCreator(jarFile, "ZIP", "MWZP");
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public static boolean executeExportAction(Program program, String command) {
        if (command.equals("Export Applet") || command.equals("Submit Project")) {
            new Thread(new ThreadedMenuAction(program, command)).start();
            return true;
        }
        return false;
    }

    public static String getLocalHostName() {
        try {
            InetAddress myHost = InetAddress.getLocalHost();
            Class<?> inetAddressClass = myHost.getClass();
            Method getCanonicalHostName = inetAddressClass.getMethod("getCanonicalHostName", new Class[0]);
            return (String)getCanonicalHostName.invoke((Object)myHost, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static void exportApplet(Program program, ProgressBarDialog progress) {
        try {
            File indexFile;
            JDK11Transformer transformer;
            String className = program.getClass().getName();
            String programName = className.substring(className.lastIndexOf(".") + 1);
            File dir = new File(System.getProperty("user.dir"));
            ExportAppletDialog dialog = new ExportAppletDialog(dir, program);
            File outDir = dialog.chooseOutputDirectory();
            if (outDir == null) {
                return;
            }
            if (outDir.exists()) {
                if (!outDir.isDirectory()) {
                    outDir = new File(outDir.getParent());
                }
            } else {
                outDir.mkdir();
            }
            JDK11Transformer jDK11Transformer = transformer = dialog.makeJDK11Compatible() ? new JDK11Transformer() : null;
            if (progress != null) {
                progress.setMaximumBumpCount(ExportTools.countResources(dir, RESOURCE_EXTENSIONS, "acm.jar") + 1);
                progress.popup();
            }
            if ((indexFile = new File(dir, "index.html")).canRead()) {
                JTFTools.copyFile(indexFile, new File(outDir, "index.html"));
            } else {
                ExportTools.dumpHTMLIndex(outDir, program, className, programName);
            }
            if (progress != null) {
                if (progress.hasBeenCancelled()) {
                    return;
                }
                progress.bump();
            }
            ExportTools.dumpJarAndResources(dir, outDir, String.valueOf(programName) + ".jar", "acm.jar", progress, transformer, dialog.exportFiles());
            if (progress != null) {
                progress.setVisible(false);
            }
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    protected static void submitProject(Program program, ProgressBarDialog progress) {
        SubmitOptions options = ExportTools.getOptions(program);
        if (options.popup() && options.isComplete()) {
            String className = program.getClass().getName();
            String programName = className.substring(className.lastIndexOf(".") + 1);
            String boundary = "==" + System.currentTimeMillis() + "==";
            String smtpServer = options.getSMTPServer();
            String authorName = options.getAuthorName();
            String authorEMail = options.getAuthorEMail();
            String instructor = options.getSubmissionEMail();
            String authorID = authorEMail;
            int atIndex = authorEMail.indexOf("@");
            if (atIndex != -1) {
                authorID = authorID.substring(0, atIndex);
            }
            String zipName = String.valueOf(programName) + "_" + authorID;
            File dir = new File(System.getProperty("user.dir"));
            if (progress != null) {
                progress.setMaximumBumpCount(ExportTools.countResources(dir, SUBMIT_EXTENSIONS, null));
                progress.popup();
            }
            PrintStream out = ExportTools.openMailStream(smtpServer, authorEMail, instructor);
            ExportTools.sendStandardHeaders(out, authorName, programName);
            out.println("Mime-Version: 1.0");
            out.println("Content-Type: multipart/mixed; boundary=\"" + boundary + '\"');
            out.println();
            out.println("--" + boundary);
            out.println("Content-Transfer-Encoding: base64");
            out.println("Content-Type: application/zip; name=" + zipName + ".zip");
            out.println("Content-Disposition: attachment; filename=" + zipName + ".zip");
            ExportTools.submitDirectory(out, zipName, progress);
            if (progress != null && progress.hasBeenCancelled()) {
                ExportTools.cancelMail(out);
            }
            out.println("--" + boundary + "--");
            out.close();
            if (progress != null) {
                progress.setVisible(false);
            }
        }
    }

    private static void dumpHTMLIndex(File outDir, Program program, String className, String programName) throws IOException {
        File outFile = new File(outDir, "index.html");
        PrintWriter wr = new PrintWriter(new FileWriter(outFile));
        Dimension size = program.getSize();
        wr.println("<html>");
        wr.println("<head>");
        wr.println("<meta name=\"generator\" content=\"ACM Java Libraries V1.1\">");
        wr.println("<title>" + programName + "</title>");
        wr.println("</head>");
        wr.println("<body>");
        wr.println("<center>");
        wr.println("<table border=2 cellpadding=0 cellspacing=0>");
        wr.println("<tr><td>");
        wr.println("<applet archive=\"" + programName + ".jar\"");
        wr.println("        code=\"" + className.replace('.', '/') + ".class\"");
        wr.println("        width=" + size.width + " height=" + size.height + ">");
        wr.println("</applet>");
        wr.println("</td></tr>");
        wr.println("</table>");
        wr.println("</center>");
        wr.println("</body>");
        wr.println("</html>");
        wr.close();
        if (Platform.isMac()) {
            String macCreator = "MSIE";
            if (Platform.compareVersion(System.getProperty("os.version"), "10") >= 0) {
                macCreator = "sfri";
            }
            Platform.setFileTypeAndCreator(outFile, "TEXT", macCreator);
        }
    }

    private static void dumpJarAndResources(File dir, File outDir, String filename, String libName, ProgressBarDialog progress, ClassTransformer transformer, boolean exportFiles) throws IOException {
        File outFile = new File(outDir, filename);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
        ExportTools.dumpJarAndResources("", dir, out, outDir, libName, progress, transformer, exportFiles);
        out.close();
        if (Platform.isMac()) {
            Platform.setFileTypeAndCreator(outFile, "ZIP", "MWZP");
        }
    }

    private static void dumpJarAndResources(String path, File dir, ZipOutputStream out, File outDir, String libName, ProgressBarDialog progress, ClassTransformer transformer, boolean exportFiles) throws IOException {
        if (progress != null && progress.hasBeenCancelled()) {
            return;
        }
        ExportTools.dumpTree(path, dir, out, outDir, progress, transformer, 0, exportFiles);
        File libJar = ExportTools.getLibrary(libName);
        if (libJar != null) {
            ZipFile jarFile = new ZipFile(libJar);
            Enumeration<? extends ZipEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!ExportTools.nameAppears(entryName, SKIP_FILES)) {
                    int ch;
                    BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));
                    if (entryName.endsWith(".class")) {
                        entry = new ZipEntry(entryName);
                        out.putNextEntry(entry);
                        ExportTools.dumpClass(in, out, transformer);
                    } else {
                        out.putNextEntry(entry);
                        JTFTools.copyBytes(in, out, entry.getSize());
                    }
                    while ((ch = ((InputStream)in).read()) != -1) {
                        out.write(ch);
                    }
                    out.closeEntry();
                    ((InputStream)in).close();
                }
                if (progress == null) continue;
                progress.bump();
            }
        }
    }

    private static void dumpTree(String path, File file, ZipOutputStream out, File outDir, ProgressBarDialog progress, ClassTransformer transformer, int level, boolean exportFiles) throws IOException {
        if (progress != null && progress.hasBeenCancelled()) {
            return;
        }
        String filename = file.getName();
        if (file.isDirectory()) {
            String[] files = file.list();
            if (level > 0) {
                path = String.valueOf(path) + filename + "/";
            }
            int i = 0;
            while (i < files.length) {
                ExportTools.dumpTree(path, new File(file, files[i]), out, outDir, progress, transformer, level + 1, exportFiles);
                ++i;
            }
        } else if (ExportTools.isResourceComponent(filename)) {
            String entryName = String.valueOf(path) + filename;
            if (entryName.startsWith("Java Classes/")) {
                entryName = entryName.substring(entryName.indexOf(47) + 1);
            }
            ZipEntry entry = new ZipEntry(entryName);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            out.putNextEntry(entry);
            if (filename.endsWith(".class")) {
                ExportTools.dumpClass(in, out, transformer);
            } else {
                JTFTools.copyBytes(in, out, file.length());
            }
            ((InputStream)in).close();
            if (exportFiles && outDir != null && !filename.endsWith(".class")) {
                in = new BufferedInputStream(new FileInputStream(file));
                outDir = new File(outDir, path);
                File outFile = new File(outDir, filename);
                outDir.mkdirs();
                BufferedOutputStream backup = new BufferedOutputStream(new FileOutputStream(outFile));
                JTFTools.copyBytes(in, backup, file.length());
                ((InputStream)in).close();
                backup.close();
                Platform.copyFileTypeAndCreator(file, outFile);
            }
            if (progress != null) {
                progress.bump();
            }
        }
    }

    private static void dumpClass(InputStream in, OutputStream out, ClassTransformer transformer) throws IOException {
        JavaClass jc = new JavaClass(new DataInputStream(in));
        if (transformer != null) {
            transformer.apply(jc);
        }
        jc.write(new DataOutputStream(out));
    }

    private static int countResources(File file, String[] extensions, String libName) {
        File libJar;
        String filename = file.getName();
        int count = 0;
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                count += ExportTools.countResources(new File(file, files[i]), extensions, null);
                ++i;
            }
        } else {
            int i = 0;
            while (i < extensions.length && count == 0) {
                if (filename.endsWith(extensions[i])) {
                    count = 1;
                }
                ++i;
            }
        }
        if (libName != null && (libJar = ExportTools.getLibrary(libName)) != null) {
            try {
                ZipFile jarFile = new ZipFile(libJar);
                Enumeration<? extends ZipEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ++count;
                    e.nextElement();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return count;
    }

    private static File getLibrary(String libName) {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            classPath = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals(libName) && !token.endsWith("/" + libName)) continue;
            return new File(token);
        }
        File dir = new File(System.getProperty("user.dir"));
        File library = new File(dir, libName);
        return library.exists() ? library : null;
    }

    private static boolean isResourceComponent(String filename) {
        int i = 0;
        while (i < RESOURCE_EXTENSIONS.length) {
            if (filename.endsWith(RESOURCE_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void submitDirectory(PrintStream out, String zipName, ProgressBarDialog progress) {
        try {
            OutputStream base64Stream = ExportTools.openBase64OutputStream(out);
            ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(base64Stream));
            ZipOutputStream dummy = new ZipOutputStream(new NullOutputStream());
            File dir = new File(System.getProperty("user.dir"));
            ExportTools.dumpZip(String.valueOf(zipName) + "/", dir, zip, dummy, true, progress);
            dummy.close();
            zip.finish();
            zip.flush();
            ExportTools.padBase64OutputStream(base64Stream);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    private static void dumpZip(String path, File file, ZipOutputStream out, ZipOutputStream dummy, boolean topLevel, ProgressBarDialog progress) throws IOException {
        if (progress != null && progress.hasBeenCancelled()) {
            return;
        }
        String filename = file.getName();
        if (file.isDirectory()) {
            String[] files = file.list();
            if (!topLevel) {
                path = String.valueOf(path) + filename + "/";
            }
            int i = 0;
            while (i < files.length) {
                ExportTools.dumpZip(path, new File(file, files[i]), out, dummy, false, progress);
                ++i;
            }
        } else if (ExportTools.isSubmitComponent(filename)) {
            String entryName = String.valueOf(path) + filename;
            ZipEntry entry = new ZipEntry(entryName);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            if (dummy != null) {
                dummy.putNextEntry(entry);
                JTFTools.copyBytes(in, dummy, file.length());
                dummy.closeEntry();
                ((InputStream)in).close();
                in = new BufferedInputStream(new FileInputStream(file));
            }
            out.putNextEntry(entry);
            JTFTools.copyBytes(in, out, file.length());
            out.closeEntry();
            ((InputStream)in).close();
            if (progress != null) {
                progress.bump();
            }
        }
    }

    private static boolean isSubmitComponent(String filename) {
        int i = 0;
        while (i < SUBMIT_EXTENSIONS.length) {
            if (filename.endsWith(SUBMIT_EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static SubmitOptions getOptions(Program program) {
        SubmitOptions options = optionsTable.get(program);
        if (options == null) {
            options = new SubmitOptions(program);
            optionsTable.put(program, options);
        }
        return options;
    }

    private static boolean nameAppears(String name, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

